#include "textures.inc"

#declare bridgeRadius = 10;
#declare bridgeDiameter = bridgeRadius*2;
#declare bridgeWidth = 4.5*feet;
#declare woodDepth = 2*inches;
#declare plankWidth = 9*inches;
#declare postHeight = 1;

#declare plank = box {
	<-bridgeWidth/2, -woodDepth/2, -plankWidth/2>
	<bridgeWidth/2, woodDepth/2, plankWidth/2>
}

#declare post = cylinder {
	<0, 0, 0>
	<0, postHeight, 0>
	woodDepth/2
}

#declare plankArc = acos(1-pow(plankWidth+1*inches, 2)/(2*pow(bridgeRadius, 2)));
#declare plankRotate = degrees(plankArc);
#declare plankCount = 180/plankRotate;
#declare railLoc = bridgeWidth/2*.95;

#declare bridge = union {
	#while (plankCount > 0)
		union {
			object {plank
				texture { DMFWood6
					rotate <0, 90, 0>
					translate <plankWidth, plankWidth, woodDepth>*plankCount*2
				}
			}

			object { post
				translate <-railLoc, 0, 0>
				texture { DMFWood6
					rotate <90, 0, 0>
					translate <plankWidth, plankWidth, woodDepth>*plankCount*2
				}
			}
			object { post
				translate <railLoc, 0, 0>
				texture { DMFWood6
					rotate <90, 0, 0>
					translate <plankWidth, plankWidth, woodDepth>*plankCount*2
				}
			}

			translate <0, bridgeRadius, 0>
			rotate <90-plankRotate*plankCount, 0, 0>
		}
		#declare plankCount = plankCount -1;
	#end
	
	torus {
		bridgeRadius+postHeight, woodDepth/2
		rotate <0, 0, 90>
		translate <-railLoc, 0, 0>
		texture { DMFWood6 }
	}
	torus {
		bridgeRadius+postHeight, woodDepth/2
		rotate <0, 0, 90>
		translate <railLoc, 0, 0>
		texture { DMFWood6 }
	}
}